window.addEventListener('load', function () {
  var checkedValue = null;
  var inputElements = document.getElementsByClassName('partner-filter-checkbox');
  var partners = document.getElementsByClassName('partner-grid-item');

  let selectedTypes = [];
  let selectedRegions = [];
  let selectedGlobal = false;

  // loop through checkboxes and listen for change event
  for (var i = 0; inputElements[i]; ++i) {
    inputElements[i].addEventListener('change', async function () {
      if (this.checked) {
        checkedValue = this.value;

        if (this.getAttribute('data-category') == 'type') {
          if (!selectedTypes.includes(checkedValue)) {
            selectedTypes.push(checkedValue);
          }
        }

        if (this.getAttribute('data-category') == 'region') {
          if (!selectedRegions.includes(checkedValue.toLowerCase())) {
            selectedRegions.push(checkedValue.toLowerCase());
          }
        }

        if (checkedValue == 'global') {
          selectedGlobal = true;
          console.log('global checked');
        }

        for (var i = 0; partners[i]; ++i) {
          if (selectedTypes.length > 0 && selectedRegions.length > 0) {
            if (selectedTypes.includes(partners[i].getAttribute('data-type')) && selectedRegions.includes(partners[i].getAttribute('data-region').toLowerCase())) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else if (selectedTypes.length > 0 && !selectedRegions.length > 0) {
            if (selectedTypes.includes(partners[i].getAttribute('data-type'))) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else if (!selectedTypes.length > 0 && selectedRegions.length > 0) {
            if (selectedRegions.includes(partners[i].getAttribute('data-region').toLowerCase())) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else {
            if (selectedGlobal) {
              if (partners[i].getAttribute('data-global')) {
                partners[i].style.display = 'flex';
              } else {
                partners[i].style.display = 'none';
              }
            }
          }
        }
      } else {
        checkedValue = this.value;

        const typeIndex = selectedTypes.indexOf(checkedValue);
        if (typeIndex > -1) {
          selectedTypes.splice(typeIndex, 1);
        }

        const regionIndex = selectedRegions.indexOf(checkedValue.toLowerCase());
        if (regionIndex > -1) {
          selectedRegions.splice(regionIndex, 1);
        }

        if (checkedValue == 'global') {
          selectedGlobal = false;
          console.log('global unchecked');
        }

        for (var i = 0; partners[i]; ++i) {
          if (selectedTypes.length > 0 && selectedRegions.length > 0) {
            if (selectedTypes.includes(partners[i].getAttribute('data-type')) && selectedRegions.includes(partners[i].getAttribute('data-region').toLowerCase())) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else if (selectedTypes.length > 0 && !selectedRegions.length > 0) {
            if (selectedTypes.includes(partners[i].getAttribute('data-type'))) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else if (!selectedTypes.length > 0 && selectedRegions.length > 0) {
            if (selectedRegions.includes(partners[i].getAttribute('data-region').toLowerCase())) {
              if (selectedGlobal) {
                if (partners[i].getAttribute('data-global')) {
                  partners[i].style.display = 'flex';
                } else {
                  partners[i].style.display = 'none';
                }
              } else {
                partners[i].style.display = 'flex';
              }
            } else {
              partners[i].style.display = 'none';
            }
          } else {
            if (selectedGlobal) {
              if (partners[i].getAttribute('data-global')) {
                partners[i].style.display = 'flex';
              } else {
                partners[i].style.display = 'none';
              }
            }
          }
        }
      }

      if (selectedTypes.length == 0 && selectedRegions.length == 0 && !selectedGlobal) {
        for (var i = 0; partners[i]; ++i) {
          partners[i].style.display = 'flex';
        }
      }
    });
  }

  function resetpartnerFilters() {
    var resetButton = document.querySelector('#partner-reset-filters');
    var checkboxes = document.getElementsByClassName('partner-filter-checkbox');

    if (checkboxes.length) {
      resetButton.addEventListener('click', function () {
        for (var i = 0; checkboxes[i]; ++i) {
          if (checkboxes[i].checked != false) {
            checkboxes[i].click();
          }
        }
      });
    }
  }

  resetpartnerFilters();
});
